<?php

namespace Bagaaravel\Commands;

use Illuminate\Console\Command;
use Bagaaravel\Acl\Models\Role;

class BagaaravelAclDefaults extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bagaaravel:acl:defaults';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Set some default roles';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $roles = config('bagaaravel-acl.defaults');
        foreach ($roles as $slug => $name) {
            Role::create(['name' => $name, 'slug' => $slug]);
        }
    }
}
