<?php

namespace Bagaaravel\Http\Controllers;

use Bagaaravel\Acl\Models\Permission;
use Bagaaravel\Acl\Permissions\BasePermission;
use Bagaaravel\Acl\Permissions\Resolver;
use Bagaaravel\Acl\Permissions\ResolverAwareTrait;
use Bagaaravel\Api\Responders\JsonApiResponder;
use Illuminate\Routing\Controller;

class PermissionController extends Controller
{

    use ResolverAwareTrait;

    protected $responder;

    public function __construct(JsonApiResponder $reponder)
    {
        $this->responder = $reponder;
    }

    public function index()
    {
        $this->responder->setCreateResourceAndRelationshipLinks(false);

        $permissions = Permission::with('roles')->get()->filter(function ($permission) {
            return auth()->user()->hasPermission($permission);
        })->makeHidden(['roles', 'users']);

        return $this->responder->transformAndRespondCollection($permissions, 200);
    }

    public function models()
    {
        $this->responder->setCreateResourceAndRelationshipLinks(false);
        $this->responder->setIncludePermissions(false);

        $modelsWithPermissions = array_filter(config('bagaaravel.jsonapi'),
            function ($model) {
                return isset($model['include_permissions']) && $model['include_permissions'];
            }
        );

        $collection = [];
        foreach ($modelsWithPermissions as $name => $modelInfo) {
            $permissionResolver = $this->getResolverForModel($modelInfo['model']);
            $data = [];

            foreach ($permissionResolver->getGenericPermissions() as $attribute => $permissions) {
                if ($permissions & Resolver::READ) {
                    $data[$attribute] = 'r';
                    $data[$attribute] .= $permissions & Resolver::WRITE ? 'w' : '';
                }
            }
            foreach ($permissionResolver->getRelationshipsGenericPermissions() as $relation => $permissions) {
                if ($permissions & Resolver::READ) {
                    $data[BasePermission::RELATIONSHIPS_PERMISSIONS][$relation] = 'r';
                    $data[BasePermission::RELATIONSHIPS_PERMISSIONS][$relation] .= $permissions & Resolver::WRITE ? 'w' : '';
                }
            }
            $permissionModel = new \Bagaaravel\Acl\Models\Detached\Permission(app($modelInfo['model']));
            $permissionModel->setRawAttributes($data);
            $collection[] = $permissionModel;
        }

        return $this->responder->transformAndRespondCollection(collect($collection), 200);
    }
}