<?php

namespace Bagaaravel\Rules;

use Illuminate\Contracts\Validation\ImplicitRule;
use Illuminate\Contracts\Validation\Rule;


class RequiredRelationship implements Rule, ImplicitRule
{

    const REQUIRED = 'required';
    const OPTIONAL = 'optional';

    protected $isRelationshipRequiredGlobally;

    protected $relationshipStatusString;

    public function __construct($isRelationshipRequiredGlobally, $relationshipStatusString)
    {
        $this->isRelationshipRequiredGlobally = $isRelationshipRequiredGlobally;
        $this->relationshipStatusString = $relationshipStatusString;

    }

    public function passes($attribute, $value)
    {

        $isCurrentRelationshipRequired = !is_null($this->getRelationshipRequiredStatus())
            ? $this->getRelationshipRequiredStatus() : $this->isRelationshipRequiredGlobally;
        if ($isCurrentRelationshipRequired) {
            if (is_null($value) || !isset($value['data']) || !count($value['data'])) {
                return false;
            }
        }

        return true;
    }

    public function message()
    {
        return trans('validation.relationship.required');
    }

    protected function getRelationshipRequiredStatus(): ?bool
    {
        if ($this->relationshipStatusString) {
            switch ($this->relationshipStatusString) {
                case self::REQUIRED:
                    return true;
                    break;
                case self::OPTIONAL:
                    return false;
                    break;

                default:
                    throw new \InvalidArgumentException('Incorrect requirement relationship definition');

            }
        }
        return null;
    }


}