<?php

namespace Bagaaravel\Rules;

use Illuminate\Contracts\Validation\ImplicitRule;
use Illuminate\Contracts\Validation\Rule;


class RequiredRelationshipDirect extends RequiredRelationship
{


    public function passes($attribute, $value)
    {
        $isCurrentRelationshipRequired = !is_null($this->getRelationshipRequiredStatus())
            ? $this->getRelationshipRequiredStatus() : $this->isRelationshipRequiredGlobally;
        if ($isCurrentRelationshipRequired) {
            if (is_null($value) || !is_array($value) || !count($value)) {
                return false;
            }
        }

        return true;
    }

    public function message()
    {
        return trans('validation.relationship.required');
    }


}