<?php

namespace Bagaaravel\Utils;

use Illuminate\Support\Facades\Auth;

class BagaaravelConfig
{
    public $config;

    /**
     * @param array $config
     */
    public function __construct($config)
    {
        $this->config = $config;
    }

    public function getVisibleRelationsForModel($model)
    {
        $config = $this->config['jsonapi'][$model];

        if (!isset($config['relationships'])) {
            return [];
        }

        $relations = array_keys($config['relationships']);

        if (!isset($config['visible_relationships'])) {
            return $relations;
        }

        if (Auth::guest()) {
            return isset($config['visible_relationships']['default'])
                ? $config['visible_relationships']['default']
                : $relations;
        }

        $roles = $config['visible_relationships'];
        $userRoles = auth()->user()->roles->pluck('slug')->all();
        $matchedRoles = array_intersect($userRoles, array_keys($roles));

        if (count($matchedRoles)) {

            $allowedRelations = [];
            foreach ($matchedRoles as $matchedRole) {
                $allowedRelations = array_merge($allowedRelations,
                    $config['visible_relationships'][$matchedRole]);
            }

            return $allowedRelations;
        }

        if (isset($roles['default'])) {
            return $config['visible_relationships']['default'];
        }

        return $relations;
    }
}