<?php

namespace Bagaar\BehatMinkApi;

use PHPUnit_Framework_Assert;

trait RelationChecks
{
    /**
     * @Then /^The json response should have a "([^"]*)" relation$/
     */
    public function theJsonResponseShouldHaveARelation( $relation )
    {
        $this->parseJsonResponse();

        $path = explode('.','data.relationships.'.$relation.'.data');

        if ( is_array($this->json_response) ){
            $array = $this->json_response;
        } else {
            $array = get_object_vars($this->json_response);
        }

        foreach( $path as $index => $key ){
            PHPUnit_Framework_Assert::assertArrayHasKey($key, $array);
            $array = is_object($array[$key]) ? get_object_vars($array[$key]) : $array[$key];
        }
    }

    /**
     * @Then /^The json response should have at least one "([^"]*)" relation$/
     */
    public function theJsonResponseShouldHaveAtLeastOneRelation( $relation )
    {
        $this->parseJsonResponse();

        $path = explode('.','data.relationships.'.$relation.'.data.0');

        if ( is_array($this->json_response) ){
            $array = $this->json_response;
        } else {
            $array = get_object_vars($this->json_response);
        }

        foreach( $path as $index => $key ){
            PHPUnit_Framework_Assert::assertArrayHasKey($key, $array);
            $array = is_object($array[$key]) ? get_object_vars($array[$key]) : $array[$key];
        }
    }


    /**
     * @Then /^The json response should have (\d+) "([^"]*)" relations$/
     */
    public function theJsonResponseShouldHaveSomeRelations( $amountOfRelations, $relation )
    {
        $this->parseJsonResponse();

        $path = explode('.','data.relationships.'.$relation.'.data');

        if ( is_array($this->json_response) ){
            $array = $this->json_response;
        } else {
            $array = get_object_vars($this->json_response);
        }

        foreach( $path as $index => $key ){
            PHPUnit_Framework_Assert::assertArrayHasKey($key, $array);
            $array = is_object($array[$key]) ? get_object_vars($array[$key]) : $array[$key];

            if($index == count($path)-1)
            {
                PHPUnit_Framework_Assert::assertCount((int)$amountOfRelations, $array);
            }
        }
    }
}