<?php

namespace Bagaar\LaravelAzureBlobStorage;

use DateTimeInterface;
use Illuminate\Filesystem\FilesystemAdapter;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Str;
use RuntimeException;
use Symfony\Component\HttpFoundation\HeaderUtils;

/**
 * @mixin FilesystemAdapter
 */
class AzureBlobStorageMacros
{
    public function temporaryDownloadUrl(): callable
    {
        return function (string $path, DateTimeInterface $expiration, ?string $filename = null, array $options = []): string {

            if (get_class($this->getAdapter()) !== AzureBlobStorageAdapter::class) {
                throw new RuntimeException('This driver does not support temporary download URLs.');
            }

            $filename = str_replace('%', '', Str::ascii($filename ?? basename($path)));

            $options = array_merge([
                'content_disposition' => HeaderUtils::makeDisposition(HeaderUtils::DISPOSITION_ATTACHMENT, $filename),
            ], $options);

            return $this->temporaryUrl($path, $expiration, $options);
        };
    }

    public function downloadTemporary(): callable
    {
        return function (string $path, DateTimeInterface $expiration, ?string $filename = null, array $options = []): RedirectResponse {
            /** @phpstan-ignore-next-line */
            return redirect()->away($this->temporaryDownloadUrl($path, $expiration, $filename, $options));
        };
    }
}
