<?php

declare(strict_types=1);

namespace Bagaar\LaravelAzureBlobStorage;

use DateTimeInterface;
use League\Flysystem\AzureBlobStorage\AzureBlobStorageAdapter as FlysystemAzureBlobStorageAdapter;
use League\Flysystem\Config;

final class AzureBlobStorageAdapter extends FlysystemAzureBlobStorageAdapter
{
    public function getUrl(string $path): string
    {
        return $this->publicUrl($path, new Config());
    }

    public function getTemporaryUrl(string $path, DateTimeInterface $expiration, array $options = []): string
    {
        return $this->temporaryUrl($path, $expiration, new Config($options));
    }
}
