<?php

declare(strict_types=1);

namespace Bagaar\LaravelAzureBlobStorage\Facades;

use Bagaar\LaravelAzureBlobStorage\AzureBlobStorageManager;
use Bagaar\LaravelAzureBlobStorage\ContainerFilesystemFactory;
use Illuminate\Contracts\Filesystem\Filesystem;
use Illuminate\Support\Facades\Facade;

/**
 * @method static ContainerFilesystemFactory connect(string|array $connection = null)
 * @method static Filesystem container(string $path, string $pathPrefix = '')
 */
class AzureBlobStorage extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return AzureBlobStorageManager::class;
    }
}
