<?php

namespace Bagaar\LaravelAzureBlobStorage;

use DateTimeInterface;
use Illuminate\Filesystem\FilesystemAdapter;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Str;

/**
 * @mixin FilesystemAdapter
 */
class AzureBlobStorageMacros
{
    public function temporaryDownloadUrl(): callable
    {
        return function (string $path, DateTimeInterface $expiration, ?string $filename = null, array $options = []): string {

            $filename = Str::ascii($filename ?? basename($path));

            // Raw url decode the filename to avoid issues with Azure Blob Storage signature verification
            $filename = rawurlencode($filename);

            $options = array_merge([
                'content_disposition' => sprintf('attachment;filename=%s', $filename),
            ], $options);

            return $this->temporaryUrl($path, $expiration, $options);
        };
    }

    public function downloadTemporary(): callable
    {
        return function (string $path, DateTimeInterface $expiration, ?string $filename = null, array $options = []): RedirectResponse {
            /** @phpstan-ignore-next-line */
            return redirect()->away($this->temporaryDownloadUrl($path, $expiration, $filename, $options));
        };
    }
}
