<?php

declare(strict_types=1);

namespace Bagaar\LaravelAzureBlobStorage;

use Illuminate\Filesystem\FilesystemAdapter;
use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\ServiceProvider;
use ReflectionException;

class AzureBlobStorageServiceProvider extends ServiceProvider
{
    /**
     * @throws ReflectionException
     */
    public function boot(AzureBlobStorageManager $manager): void
    {
        Storage::extend('azure_blob_storage', function (Application $app, array $config) use ($manager) {

            $container = $config['container'];
            $pathPrefix = $config['path_prefix'] ?? '';

            return $manager->connect($config['connection'] ?? null)->container($container, $pathPrefix);
        });

        FilesystemAdapter::mixin(new AzureBlobStorageMacros());
    }

    public function register(): void
    {
        $this->app->singleton(AzureBlobStorageManager::class, function (Application $app) {
            return new AzureBlobStorageManager((array) $app['config']->get('services.azure_blob_storage.connections') ?: []);
        });
    }

    public function provides(): array
    {
        return [
            AzureBlobStorageManager::class,
        ];
    }
}
