FROM php:8.1-fpm-alpine

RUN ln -s "$PHP_INI_DIR/php.ini-production" "$PHP_INI_DIR/php.ini"

ARG xdebug
ARG coverage
ARG uid=1000
ARG gid=1000
ARG ostype=Linux


WORKDIR /src

RUN if [ ${ostype} == Linux ] ; then \
    echo "@edge http://dl-2.alpinelinux.org/alpine/edge/community/" >> /etc/apk/repositories && \
    apk update && \
    apk add shadow@edge && \
    usermod -u $uid www-data && groupmod -g $gid www-data; \
    fi

RUN curl -sS https://getcomposer.org/installer | php && \
        chmod +x composer.phar && \
        mv composer.phar /usr/local/bin/composer

RUN chown -R www-data:www-data /src

RUN apk update && \
    apk add zlib-dev libpng-dev libjpeg-turbo-dev freetype-dev libzip-dev && \
    apk add mysql-client mariadb-connector-c && \
    docker-php-source extract && \
    docker-php-ext-configure gd --with-freetype --with-jpeg && \
    docker-php-ext-install gd zip pdo_mysql opcache && \
    docker-php-source delete


RUN if [ "$xdebug" = "true" ] ; then \
    apk update && \
    apk add --update linux-headers && \
    apk add autoconf build-base && \
    docker-php-source extract && \
    pecl channel-update pecl.php.net && \
    pecl install xdebug && \
    docker-php-source delete && \
    docker-php-ext-enable xdebug; \
    fi

#Set up debugger
RUN echo "xdebug.mode=debug" >> "$PHP_INI_DIR/conf.d/xdebug-settings.ini" && \
    echo "xdebug.client_port=9000" >> "$PHP_INI_DIR/conf.d/xdebug-settings.ini" && \
    echo "xdebug.client_host=host.docker.internal" >> "$PHP_INI_DIR/conf.d/xdebug-settings.ini" && \
    echo "xdebug.start_with_request=true" >> "$PHP_INI_DIR/conf.d/xdebug-settings.ini"

RUN if [ "$coverage" = "true" ] ; then \
    echo "xdebug.mode=coverage" >> "$PHP_INI_DIR/conf.d/xdebug-settings.ini"; \
    fi

ENV PHP_IDE_CONFIG=serverName=docker
ENV COMPOSER_MEMORY_LIMIT=-1

#php settings
RUN echo "upload_max_filesize=64M" > $PHP_INI_DIR/conf.d/upload.ini
RUN echo "expose_php=Off" >> $PHP_INI_DIR/conf.d/expose.ini

#fpm settings
RUN echo "pm = static" >> $PHP_INI_DIR/../php-fpm.d/www.conf && \
    echo "pm.max_children = 20" >> $PHP_INI_DIR/../php-fpm.d/www.conf && \
    echo "pm.max_requests = 1000" >> $PHP_INI_DIR/../php-fpm.d/www.conf && \
    echo "pm.status_path = /status" >> $PHP_INI_DIR/../php-fpm.d/www.conf


