<?php

namespace Bagaar\LaravelAzureStorage\Providers;

use Illuminate\Filesystem\FilesystemAdapter;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\ServiceProvider;
use League\Flysystem\Filesystem;
use MicrosoftAzure\Storage\Blob\BlobRestProxy;

class AzureBlobStorageServiceProvider extends ServiceProvider
{
    /**
     * Perform post-registration booting of services.
     *
     * @return void
     */
    public function boot()
    {
        Storage::extend('azure', function ($app, $config) {
            $accountName = $config['name'];
            $accountKey = $config['key'];
            $endpointSuffix = $config['endpointSuffix'];
            $connectionString = "DefaultEndpointsProtocol=https;AccountName=$accountName;AccountKey=$accountKey;EndpointSuffix=$endpointSuffix";
            $client = BlobRestProxy::createBlobService($connectionString);
            $ttl = $config['sasExpiryMinutes'];

            $adapter = new AzureBlobStorageAdapter($client, $config['container'], $accountKey, $ttl);
            $filesystem = new Filesystem($adapter, $config);
            $filesystemAdapter = new FilesystemAdapter($filesystem, $adapter, $config);

            return $filesystemAdapter;
        });
    }

    /**
     * Register bindings in the container.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
