# laravel-azure-storage

## Description

This package adds support for Azure Blob Storage.


## Installation

```bash
composer require bagaar/laravel-azure-storage
```

## Environment vars and config

Add to your `.env`:

```
FILESYSTEM_PRIVATE=azure-private
FILESYSTEM_PUBLIC=azure-public

NOVA_STORAGE_DISK=azure-private

AZURE_PRIVATE_STORAGE_NAME=projectprivdev
AZURE_PUBLIC_STORAGE_NAME=projectpubdev

AZURE_PRIVATE_STORAGE_KEY="YOURKEYHERE"
AZURE_PUBLIC_STORAGE_KEY="YOURKEYHERE"

AZURE_PRIVATE_STORAGE_CONTAINER=private
AZURE_PUBLIC_STORAGE_CONTAINER=public

AZURE_ENDPOINT_SUFFIX=core.windows.net

AZURE_PRIVATE_STORAGE_EXPIRY_MINUTES=60
```

Add to your `config/filesystems.php`, under `disks`, e.g.:

```php
        'azure-private' => [
            'driver' => 'azure',
            'name' => env('AZURE_PRIVATE_STORAGE_NAME'),
            'key' => env('AZURE_PRIVATE_STORAGE_KEY'),
            'endpointSuffix' => env('AZURE_ENDPOINT_SUFFIX', 'core.windows.net'),
            'container' => env('AZURE_PRIVATE_STORAGE_CONTAINER', null),
            'url' => ('https://'
                .env('AZURE_PRIVATE_STORAGE_NAME')
                .'.blob.'.env('AZURE_ENDPOINT_SUFFIX').'/'
                .env('AZURE_PRIVATE_STORAGE_CONTAINER').'/'
            ),
            'sasExpiryMinutes' => env('AZURE_PRIVATE_STORAGE_EXPIRY_MINUTES', 60),
            'throw' => true,
        ],

        'azure-public' => [
            'driver' => 'azure',
            'name' => env('AZURE_PUBLIC_STORAGE_NAME'),
            'key' => env('AZURE_PUBLIC_STORAGE_KEY'),
            'endpointSuffix' => env('AZURE_ENDPOINT_SUFFIX', 'core.windows.net'),
            'container' => env('AZURE_PUBLIC_STORAGE_CONTAINER'),
            'url' => ('https://'
                .env('AZURE_PUBLIC_STORAGE_NAME')
                .'.blob.'.env('AZURE_ENDPOINT_SUFFIX').'/'
                .env('AZURE_PUBLIC_STORAGE_CONTAINER').'/'
            ),
            'sasExpiryMinutes' => 0,
            'throw' => true,
        ],
```


## Usage

```php
$publicUrl = Storage::disk('azure-public')->url('uploads/uuid.jpg');

$expirationDate = (now())->add(new DateInterval('PT'.'60'.'M'));
$privateUrl = Storage::disk('azure-private')->temporaryUrl('uploads/uuid.jpg', $expirationDate);
```
