<?php

namespace Bagaar\LaravelCamelAttributes\Models\Traits;

use Spatie\Translatable\HasTranslations;

trait CamelAttributesAndHasTranslations
{
    use CamelAttributes, HasTranslations {
        CamelAttributes::setAttribute as setAttributeCamel;
        HasTranslations::setAttribute as setAttributeTranslation;
    }

    public function setAttribute($key, $value)
    {
        if ($this->isTranslatableAttribute($key)) {
            $this->setAttributeTranslation(\Str::snake($key), $value);
        } else {
            $this->setAttributeCamel($key, $value);
        }
    }
}
