<?php

namespace LaravelCamelAttributesApp\Models;

use Bagaar\LaravelCamelAttributes\Models\Traits\CamelAttributes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TestModel extends \Illuminate\Database\Eloquent\Model
{
    use CamelAttributes;

    protected $fillable = [
        'test_attribute',
    ];

    /**
     * @return BelongsTo<RelationModel, $this>
     */
    public function relationModel()
    {
        return $this->belongsTo(RelationModel::class);
    }
}
