# Laravel Model Camel Attributes

## Description

This package makes model attributes available using camel casing.

## Installation

```bash
composer require bagaar/laravel-camel-attributes
```

## Usage

```php
class TestModel extends \Illuminate\Database\Eloquent\Model
{
    use CamelAttributes;
}
```

## Using together with `spatie/laravel-translatable`

```php
Class TranslatableModel extends Model
{
    use CamelAttributesAndHasTranslations;

    protected $translatable = [
        'test_translatable_attribute'
    ];
}
```
