<?php

namespace Bagaar\LaravelCamelAttributes\Models\Traits;

use Illuminate\Support\Str;

trait CamelAttributes
{
    public function initializeCamelAttributes()
    {
        $fillable = $this->getFillable();
        foreach ($fillable as $attr) {
            if (! in_array(Str::camel($attr), $fillable)) {
                $fillable[] = Str::camel($attr);
            }
        }

        $this->fillable($fillable);
    }

    public function getAttribute($key)
    {
        if (! method_exists($this, $key)) {
            return parent::getAttribute(Str::snake($key));
        } else {
            return parent::getAttribute($key);
        }
    }

    public function setAttribute($key, $value)
    {
        return parent::setAttribute(Str::snake($key), $value);
    }
}
