<?php

namespace Bagaar\LaravelFileUploads\Console;

use Bagaar\LaravelFileUploads\Models\Upload;
use Illuminate\Console\Command;

class CleanupGraphqlUploads extends Command
{
    protected $signature = 'laravel-file-uploads:cleanup';

    protected $description = 'Cleanup abandoned uploads';

    public function handle()
    {
        $uploads = Upload::where('is_used', false)
            ->where('created_at', '<', now()->subHours(config('laravel-file-uploads.scheduled_cleanup.delete_after_hours')))
            ->get();

        $uploads->each(function ($upload) {
            $upload->deleteFile();
            $upload->forceDelete();
        });
    }
}