<?php

namespace Bagaar\LaravelFileUploads\Http\Controllers;

use Bagaar\LaravelFileUploads\Http\Requests\UploadRequest;
use Bagaar\LaravelFileUploads\Models\Upload;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;

class UploadController
{
    public function store(UploadRequest $request): JsonResponse
    {
        $upload = Upload::create();

        $path = Storage::disk(config('laravel-file-uploads.disk'))->putFileAs(
            config('laravel-file-uploads.path_prefix'),
            $request->file('file'),
            $upload->id
        );

        $upload->update([
            'path' => $path,
            'original_name' => $request->file('file')->getClientOriginalName(),
            'mime_type' => $request->file('file')->getMimeType(),
            'size' => $request->file('file')->getSize(),
        ]);

        return Response::json($upload, 201);
    }
}
