<?php

namespace Bagaar\LaravelFileUploads\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Upload extends Model
{
    use HasUuids;

    protected $fillable = [
        'original_name',
        'path',
        'mime_type',
        'size'
    ];

    public function deleteFile(): void
    {
        Storage::disk(config('laravel-file-uploads.disk'))->delete($this->path);
    }
}