<?php

namespace Bagaar\LaravelFileUploads\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UploadRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules(): array
    {
        $rules = ['required', 'file'];
        $mimeTypes = config('laravel-file-uploads.allowed_mimetypes');
        if ($mimeTypes !== '*') {
            if (is_array($mimeTypes)) {
                $rules[] = 'mimetypes:' . implode(',', $mimeTypes);
            } else {
                $rules[] = 'mimetypes:' . $mimeTypes;
            }
        }
        $bytes = $this->convertFileSizeToBytes(config('laravel-file-uploads.max_filesize'));
        $rules[] = 'max:' . $bytes / 1024;
        $rules = array_merge($rules, config('laravel-file-uploads.extra_validation_rules'));

        return [
            'file' => $rules
        ];
    }

    private function convertFileSizeToBytes($size)
    {
        $units = ['K', 'M', 'G'];
        $unit = preg_match('/[KMGkmg]/i', $size, $matches) ? strtoupper($matches[0]) : '';
        if (!$unit) {
            return $size;
        }
        $value = preg_replace('/[KMGkmg]/i', '', $size);
        $unit = $matches[0];
        return $value * pow(1024, array_search($unit, $units) + 1);
    }
}
