<?php

namespace Bagaar\LaravelFileUploads\Http\Controllers;

use Bagaar\LaravelFileUploads\Http\Requests\UploadRequest;
use Bagaar\LaravelFileUploads\Models\Upload;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;

class UploadController
{
    public function store(UploadRequest $request): JsonResponse
    {
        $upload = Upload::create();

        // Default path will be `/uploads/uuid/original_filename.png`
        $path = Storage::disk(config('laravel-file-uploads.disk'))->putFileAs(
            implode("/", array(config('laravel-file-uploads.path_prefix'), $upload->id)),
            $request->file('file'),
            $request->file('file')->getClientOriginalName()
        );

        $upload->update([
            'path' => $path,
            'original_name' => $request->file('file')->getClientOriginalName(),
            'mime_type' => $request->file('file')->getMimeType(),
            'size' => $request->file('file')->getSize(),
        ]);

        return Response::json($upload, 201);
    }
}
