<?php

namespace Bagaar\LaravelFileUploads\Models;

use Bagaar\LaravelCamelAttributes\Models\Traits\CamelAttributes;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

/**
 * Bagaar\LaravelFileUploads\Models\Upload
 *
 * @property string $id
 * @property string|null $path
 * @property string|null $original_name
 * @property string|null $mime_type
 * @property int|null $size
 * @property bool $is_used
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|Bagaar\LaravelFileUploads\Models\Upload newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Upload newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Upload query()
 * @mixin \Eloquent
 */
class Upload extends Model
{
    use HasUuids;
    use CamelAttributes;

    protected $casts = [
        'is_used' => 'boolean',
    ];

    protected $fillable = [
        'is_used',
        'original_name',
        'path',
        'mime_type',
        'size'
    ];

    public function deleteFile(): void
    {
        Storage::disk(config('laravel-file-uploads.disk'))->delete($this->path);
    }
}