<?php

namespace Bagaar\LaravelFileUploads;

use Bagaar\LaravelFileUploads\Console\CleanupGraphqlUploads;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider as BaseServiceProvider;
use Illuminate\Console\Scheduling\Schedule;

class ServiceProvider extends BaseServiceProvider
{
    public function boot()
    {
        $this->publish();
        $this->registerRoutes();
        $this->registerCommands();
        $this->scheduleCommands();
        $this->loadMigrations();
        $this->registerDirectives();
    }

    public function register()
    {
        $this->mergeConfigFrom(__DIR__ . '/../config/laravel-file-uploads.php', 'laravel-file-uploads');
    }

    private function publish(): void
    {
        $this->publishes([
            __DIR__ . '/../config/laravel-file-uploads.php' => config_path('laravel-file-uploads.php'),
        ], 'config');
    }

    private function registerRoutes(): void
    {
        Route::middleware(config('laravel-file-uploads.middlewares'))
            ->group(__DIR__ . '/../routes/laravel-file-uploads.php');
    }

    private function registerCommands(): void
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                CleanupGraphqlUploads::class,
            ]);
        }
    }

    private function scheduleCommands(): void
    {
        if ($this->app->runningInConsole()) {
            $this->app->booted(function () {
                $schedule = $this->app->make(Schedule::class);
                if (config('laravel-file-uploads.scheduled_cleanup.enabled')) {
                    $schedule->command(CleanupGraphqlUploads::class)->cron(
                        config('laravel-file-uploads.scheduled_cleanup.cron')
                    );
                }
            });
        }
    }

    private function loadMigrations(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../database/migrations');
    }

    private function registerDirectives(): void
    {
        $middlewares = config('lighthouse.field_middleware', []);
        $middlewares[] = \Bagaar\LaravelFileUploads\GraphQL\Directives\LinkUploadDirective::class;
        config(['lighthouse.field_middleware' => $middlewares]);
        $directivePaths = config('lighthouse.namespaces.directives', []);
        $directivePaths[] = 'Bagaar\\LaravelFileUploads\\GraphQL\\Directives';
        config(['lighthouse.namespaces.directives' => $directivePaths]);
    }
}
