<?php

return [

    /**
     * The base url to use for the graphql-uploads routes.
     */
    'url' => env('LARAVEL_FILE_UPLOADS_URL', '/uploads'),

    /**
     * The disk to use for storing the uploads.
     */
    'disk' => env('LARAVEL_FILE_UPLOADS_DISK', 'public'),

    /**
     * The path where the uploads will be stored on the disk.
     */
    'path_prefix' => env('LARAVEL_FILE_UPLOADS_PATH_PREFIX', ''),

    /**
     * Array of middlewares to be applied to the upload routes.
     */
    'middlewares' => [],

    /**
     * The maximum file size in bytes.
     * Or in PHP human readable format: https://www.php.net/manual/en/faq.using.php#faq.using.shorthandbytes
     */
    'max_filesize' => env('LARAVEL_FILE_UPLOADS_MAX_FILESIZE', ini_get('upload_max_filesize')),

    /**
     * Allowed mimetypes.
     * '*' means all mimetypes are allowed.
     * You can also specify an array of mimetypes or a comma separated string.
     * @example ['image/jpeg', 'image/png', 'image/gif'] or 'image/jpeg,image/png,image/gif'
     */
    'allowed_mimetypes' => env('LARAVEL_FILE_UPLOADS_ALLOWED_MIMETYPES', '*'),

    /**
     * Extra validation rules for the file.
     */
    'extra_validation_rules' => [],

    /**
     * Scheduled cleanup of dangling uploads.
     */
    'scheduled_cleanup' => [
        'enabled' => env('LARAVEL_FILE_UPLOADS_SCHEDULED_CLEANUP_ENABLED', false),
        'delete_after_hours' => env('LARAVEL_FILE_UPLOADS_SCHEDULED_CLEANUP_DELETE_AFTER_HOURS', 7 * 24),
        'cron' => env('LARAVEL_FILE_UPLOADS_SCHEDULED_CLEANUP_CRON', '0 0 * * *'),
    ],
];