<?php

namespace Tests;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Nuwave\Lighthouse\Testing\MakesGraphQLRequests;

class TestCase extends \Orchestra\Testbench\TestCase
{
    use RefreshDatabase, MakesGraphQLRequests;

    protected $enablesPackageDiscoveries = true;

    protected function getPackageProviders($app)
    {
        return [
            \Bagaar\LaravelFileUploads\ServiceProvider::class,
            \Nuwave\Lighthouse\LighthouseServiceProvider::class
        ];
    }

    public function setUp(): void
    {
        parent::setUp();
        $this->loadMigrationsFrom(__DIR__ . '/Data/migrations');
        $this->artisan('vendor:publish', ['--tag' => 'lighthouse-config']);
        config(['lighthouse.schema.register' => __DIR__ . '/Data/graphql/schema.graphql']);
        config(['lighthouse.namespaces.models' => ['Tests\\Data\\Models']]);
    }
}
