<?php
namespace Bagaar\LaravelTemporalTables\Database\Query\Macros;

use Bagaar\LaravelTemporalTables\Services\TemporalVersioning\VersioningFacade;
use Illuminate\Database\Query\Builder;

class TemporalJoin
{
    /**
     * @var Builder
     */
    private $builder;
    private $table;
    private $first;
    /**
     * @var null
     */
    private $operator;
    /**
     * @var null
     */
    private $second;
    /**
     * @var string
     */
    private $type;
    /**
     * @var false
     */
    private $where;
    /**
     * @var null
     */
    private $temporal_data;

    /**
     * @param  Builder  $builder
     * @param $table
     * @param $first
     * @param  null  $operator
     * @param  null  $second
     * @param  string  $type
     * @param  false  $where
     * @param  null  $temporal_data
     */
    public function __construct(Builder $builder, $table, $first, $operator = null, $second = null, $type = 'inner', $where = false, $temporal_data = null)
    {
        $this->builder = $builder;
        $this->table = $table;
        $this->first = $first;
        $this->operator = $operator;
        $this->second = $second;
        $this->type = $type;
        $this->where = $where;
        $this->temporal_data = $temporal_data;
    }


    public function execute()
    {
        $this->builder->join($this->table, function($joinBuilder){
            $method = $this->where ? 'where' : 'on';
            $joinBuilder->$method($this->first, $this->operator, $this->second);

            if ( $this->temporal_data ){
                VersioningFacade::addTemporalScopeToQueryBuilder($joinBuilder, $this->table, $this->temporal_data);
            }
        }, null, null, $this->type);
    }

}
