<?php
namespace Bagaar\LaravelTemporalTables\Database\Query\Grammars;

use Illuminate\Database\Query\Builder;

class MySqlGrammar extends \Illuminate\Database\Query\Grammars\MySqlGrammar
{

    public function compileInsert(Builder $query, array $values)
    {
        if ( $query->isTemporalTable ?? false ){
            $query->from = $this->removeHistory($query->from);
            $values = $this->removeHistoryKeys($values);
        }

        return parent::compileInsert($query, $values);
    }

    public function compileUpdate(Builder $query, array $values)
    {
        if ( $query->isTemporalTable ?? false ){
            $query->from = $this->removeHistory($query->from);
            $values = $this->removeHistoryKeys($values);
            $query->wheres = $this->removeHistoryFromWheres($query->wheres);
        }

        return parent::compileUpdate($query, $values);
    }

    public function compileUpsert(Builder $query, array $values, array $uniqueBy, array $update)
    {
        if ( $query->isTemporalTable ?? false ){
            $query->from = $this->removeHistory($query->from);
            $values = $this->removeHistoryKeys($values);
            $update = $this->removeHistoryKeys($update);
            $query->wheres = $this->removeHistoryFromWheres($query->wheres);
        }

        return parent::compileUpsert($query, $values, $uniqueBy, $update);
    }

    public function compileDelete(Builder $query)
    {
        if ( $query->isTemporalTable ?? false ){
            $query->from = $this->removeHistory($query->from);
            $query->wheres = $this->removeHistoryFromWheres($query->wheres);
        }

        return parent::compileDelete($query);
    }

    protected function removeHistory(string $string): string
    {
        return str_replace('_history', '', $string);
    }

    protected function removeHistoryKeys(array $values): array
    {
        $new_values = [];
        foreach ($values as $key => $value){
            $key = $this->removeHistory($key);
            $new_values[$key] = $value;
        }

        return $new_values;
    }


    protected function removeHistoryFromWheres(array $wheres)
    {
        $new_values = [];
        foreach ($wheres as $value){
            if ( array_key_exists('column', $value) ){
                $value['column'] = $this->removeHistory($value['column']);
            }
            $new_values[] = $value;
        }
        return $new_values;
    }

}
