<?php

namespace Bagaar\LaravelTemporalTables\Providers;

use Bagaar\LaravelTemporalTables\Database\MySqlConnection;
use Bagaar\LaravelTemporalTables\Database\Query\Macros\Temporal;
use Bagaar\LaravelTemporalTables\Database\Query\Macros\TemporalJoin;
use Bagaar\LaravelTemporalTables\Services\TemporalVersioning\VersioningService;
use Illuminate\Database\Connection;
use Illuminate\Database\Query\Builder;
use Illuminate\Support\ServiceProvider;

class TemporalServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //

        Builder::macro('temporal', function($temporal_data){
            return with(new Temporal($this, $temporal_data))->execute();
        });

        Builder::macro('temporalJoin', function($table, $first, $operator = null, $second = null, $type = 'inner', $where = false, $temporal_data = null){
            return with(new TemporalJoin($this, $table, $first, $operator, $second, $type, $where, $temporal_data))->execute();
        });

        Connection::resolverFor('mysql', function ($connection, $database, $prefix, $config) {
            return new MySqlConnection($connection, $database, $prefix, $config);
        });

        $this->app->scoped('Versioning', VersioningService::class);
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
