<?php

namespace Bagaar\Translation\Commands;

use Exception;
use Illuminate\Console\Command;
use Bagaar\Translation\Translation;

class Download extends Command
{
    protected $signature = 'translation:download {--include-reference:Download reference language as well}';
    protected $description = 'Download all languages from POEditor';

    public function handle(Translation $translationService): void
    {
        try {
            $this->info('⬇️  Preparing to download languages');

            $languages = $translationService->listProjectLanguages();
            if (!$this->hasOption("include-reference")){
                $languages = $languages->filter(function ($item) use ($translationService){
                    return $item['code'] != $translationService->referenceLanguage;
                });
            }

            $languages->each(function ($language) use ($translationService){
                $this->info("    Downloading {$language['code']}: {$language['translations']} transaltions = {$language['percentage']}%");
                $translationService->download($language);
            });

            $this->info('⬇️  Finished downloading languages: ' . $languages->map(fn($item) => $item['code'])->implode(', '));
        } catch (Exception $e) {
            $this->error($e->getMessage());
        }
    }
}
