<?php

namespace Bagaar\Translation\Commands;

use Exception;
use Illuminate\Console\Command;
use Bagaar\Translation\Translation;

class Scan extends Command
{
    protected $signature = 'translation:scan';
    protected $description = 'Scan code base for translation variables and merge them into the reference language';

    public function handle(Translation $translationService): void
    {
        try {
            $this->info('🔎 Preparing to scan code base');
            $this->info('   Finding all translation variables');

            $newKeys = $translationService->scan();

            $this->info("   {$newKeys->count()} new translations added to {$translationService->referenceLanguageFilename}");
            $this->info('✅  Finished scanning code base.');
        } catch (Exception $e) {
            $this->error($e->getMessage());
        }
    }
}
