<?php

namespace Bagaar\Translation;

use Illuminate\Support\ServiceProvider;
use Bagaar\Translation\Commands\Scan;
use Bagaar\Translation\Commands\UploadReference;
use Bagaar\Translation\Commands\Download;
use Bagaar\Translation\Commands\CreateJs;
use Bagaar\Translation\Commands\AddTerms;

class TranslationServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this->publishes([
            __DIR__ . '/../config/translation.php' => config_path('translation.php'),
        ], 'config');

        if ($this->app->runningInConsole()) {
            $this->commands([
                Scan::class,
                UploadReference::class,
                Download::class,
            ]);
        }
    }

    public function register(): void
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../config/translation.php', 'translation'
        );

        $this->app->singleton(Translation::class, function () {
            return new Translation();
        });
    }
}
