<?php

namespace Bagaar\Translation;

use Bagaar\Translation\Commands\Download;
use Bagaar\Translation\Commands\Lint;
use Bagaar\Translation\Commands\Scan;
use Bagaar\Translation\Commands\UploadReference;
use Illuminate\Support\ServiceProvider;

class TranslationServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this->publishes([
            __DIR__.'/../config/translation.php' => config_path('translation.php'),
        ], 'config');

        if ($this->app->runningInConsole()) {
            $this->commands([
                Scan::class,
                UploadReference::class,
                Download::class,
                Lint::class,
            ]);
        }
    }

    public function register(): void
    {
        $this->mergeConfigFrom(
            __DIR__.'/../config/translation.php', 'translation'
        );

        $this->app->singleton(Translation::class, function () {
            return new Translation();
        });
        if (config('translation.json_fallback_enabled')) {
            $this->registerJsonFallbackTranslator();
        }
    }

    private function registerJsonFallbackTranslator(): void
    {
        $this->app->singleton('translator', function ($app) {
            $loader = $app['translation.loader'];
            $locale = $app['config']['app.locale'];

            $trans = new JsonFallbackTranslator($loader, $locale);
            $trans->setFallback($app['config']['app.fallback_locale']);

            return $trans;
        });
    }
}
