<?php

namespace Bagaar\Translation\Commands;

use Bagaar\Translation\Linter;
use Illuminate\Console\Command;

class Lint extends Command
{
    protected $signature = 'translation:lint';

    protected $description = 'Lint all languages strings, look for mismatches with the reference';

    public function handle(Linter $linter): int
    {
        $this->info('👓️  Linting local language files');

        $errors = $linter->lintAllLanguages();
        $count = count($errors);
        if (! empty($errors)) {
            foreach ($errors as $error) {
                $this->error($error);
            }
            $this->error("👓️❌  Found {$count} linting errors.");

            return 1;
        }

        $this->info('👓️✅️  Finished linting');

        return 0;
    }
}
