<?php

namespace Bagaar\Translation;

use const DIRECTORY_SEPARATOR;
use Illuminate\Support\Collection;

class TranslationHelper
{
    public static function getLanguagePath(string $languageCode): string
    {
        return app()->langPath().DIRECTORY_SEPARATOR.$languageCode.'.json';
    }

    public static function getFileContent(string $path): Collection
    {
        if (! file_exists($path)) {
            throw new \Exception("File not found: {$path}");
        }

        return collect((array) json_decode((string) file_get_contents($path), true));
    }
}
