<?php

namespace Bagaar\Translation\Exceptions;

use Exception;

class POEditorException extends Exception
{
    public static function noApiKey(): self
    {
        return new self('Missing POEDITOR_API_KEY, please add it in .env');
    }

    public static function noProjectId(): self
    {
        return new self('Missing POEDITOR_PROJECT_ID, please add it in .env');
    }

    public static function communicationError(string $message): self
    {
        return new self("Error in communication with POEditor: {$message}");
    }

    public static function unableToCreateJsDirectory(string $directory): self
    {
        return new self("Unable to create directory '{$directory}', please check permissions");
    }
}
