<?php

namespace Bagaar\Translation;

use const DIRECTORY_SEPARATOR;

use Illuminate\Support\Str;

class Linter
{
    public string $referenceLanguage;

    public string $referenceLanguageFilename;

    private Translation $translationService;

    public function __construct(Translation $translationService)
    {
        $this->referenceLanguage = config('translation.reference_language');
        $this->referenceLanguageFilename = app()->langPath() . DIRECTORY_SEPARATOR . $this->referenceLanguage . '.json';
        $this->translationService = $translationService;
    }

    public function lint(string $languageCode): array
    {
        $content = TranslationHelper::getFileContent(TranslationHelper::getLanguagePath($languageCode));
        $referenceContent = TranslationHelper::getFileContent($this->referenceLanguageFilename);

        $errors = [];
        // make sure all the variables are defined in each translation.
        $referenceContent->each(function ($value, $key) use ($content, &$errors, $languageCode) {
            if (!isset($content[$key])) {
                return true;
            }
            $langValue = $content[$key];
            $refVars = Str::matchAll('/(:[A-z-_]+)/', $value);
            $langVars = Str::matchAll('/(:[A-z-_]+)/', $langValue);
            if ($refVars->diff($langVars)->isNotEmpty()) {
                foreach ($refVars->diff($langVars) as $missingVariables) {
                    $errors[] = "{$languageCode} ({$key}) => Missing variable '$missingVariables'";
                }
            }

            return true;
        });

        return $errors;
    }

    public function lintAllLanguages(): array
    {
        $languageCodes = $this->translationService->getLocalLanguageFiles();

        $errors = $languageCodes->flatMap(function ($language) {
            return $this->lint($language['code']);
        });

        return $errors->toArray();
    }
}
