<?php

namespace Bagaar\Translation\Commands;

use Bagaar\Translation\Translation;
use Exception;
use Illuminate\Console\Command;

class UploadReference extends Command
{
    protected $signature = 'translation:upload-reference';

    protected $description = 'Add and Upload all reference translations to POEditor. It will override reference translations but won\'t delete terms';

    public function handle(Translation $translationService): void
    {
        try {
            $this->info("⬆️  Preparing to upload terms and translations from {$translationService->referenceLanguageFilename}");

            $response = $translationService->addTerms();
            $this->info("    Added {$response['result']['terms']['added']} terms");
            $response = $translationService->addReferenceTranslations();
            $this->info("    Added {$response['result']['translations']['added']} reference translations");
            $response = $translationService->updateReferenceTranslations();
            $this->info("    Updated {$response['result']['translations']['updated']} reference translations");

            $this->info('⬆️  Finished uploading all reference translations translations');
        } catch (Exception $e) {
            $this->error($e->getMessage());
        }
    }
}
