# Laravel Translation

## Description

This package allows you to scan your app for translations and create your reference *.json file.

It also allows you to upload your reference translation file to [poeditor](https://www.poeditor.com).
And download all the translated languages from poeditor.

Next to that it provides a fallback mechanism for json translation files. This is by default not supported by Laravel.
The following ticket contains more information: https://github.com/laravel/framework/issues/41565

## Installation

You can install the package via composer:

```bash
composer require bagaar/laravel-translation
```

The package will automatically register its service provider.

To publish the config file to `config/translation.php` run:

```bash
php artisan vendor:publish --provider="Bagaar\Translation\TranslationServiceProvider"
```

This is the default contents of the configuration:

```php
return [

    /*
    |--------------------------------------------------------------------------
    | Reference Language
    |--------------------------------------------------------------------------
    |
    | Here you may specify which of language is your reference language.
    | The reference language select will be created as json file when scanning.
    | It will also be the file it reads and uploads to POEditor.
    |
    */

    'reference_language' => 'en-reference',

    /*
    |--------------------------------------------------------------------------
    | Functions
    |--------------------------------------------------------------------------
    |
    | Here you define an array describing all the function names to scan files for.
    |
    */

    'functions' => ['__'],

    /*
    |--------------------------------------------------------------------------
    | Excluded directories
    |--------------------------------------------------------------------------
    |
    | Here you define which directories are excluded from scan.
    |
    */

    'excluded_directories' => ['vendor', 'storage', 'public', 'node_modules'],

    /*
    |--------------------------------------------------------------------------
    | Extensions
    |--------------------------------------------------------------------------
    |
    | Here you define an array describing all the file extensions to scan through.
    |
    */

    'extensions' => ['*.php', '*.vue'],

    /*
    |--------------------------------------------------------------------------
    | API Key
    |--------------------------------------------------------------------------
    |
    | Here you define your API Key for POEditor.
    |
    | More info: https://poeditor.com/account/api
    |
    */

    'api_key' => env('POEDITOR_API_KEY'),

    /*
    |--------------------------------------------------------------------------
    | Project Id
    |--------------------------------------------------------------------------
    |
    | Here you define the project Id to upload / download from.
    |
    */

    'project_id' => env('POEDITOR_PROJECT_ID'),

    /*
    |--------------------------------------------------------------------------
    | Force full language codes
    |--------------------------------------------------------------------------
    |
    | If false, keep POEditor default language codes ('nl', 'nl-be'),
    | or set to true to force codes to be like ('nl-NL', 'nl-BE')
    |
    */

    'force_full_language_codes' => env('POEDITOR_FORCE_FULL_LANGUAGE_CODES', true),
    
        /*
    |--------------------------------------------------------------------------
    | Language Code Separator
    |--------------------------------------------------------------------------
    |
    | If force_full_language_codes is enabled use this separator to join the language code with the country code
    | example: language_code_separator="_" => ('nl_NL', 'nl_BE')
    |
    */

    'language_code_separator' => env('POEDITOR_LANGUAGE_CODE_SEPARATOR', '-'),
    
    /*
    |--------------------------------------------------------------------------
    | Json Fallback locale enabled
    |--------------------------------------------------------------------------
    |
    | By default, laravel falls back to the translation key when using json.
    | Enabling this feature activates the JsonFallbackTranslator.
    | This uses the fallback locale to retrieve the backup translation.
    |
    */
    
    'json_fallback_enabled' => env('JSON_FALLBACK_LOCALE_ENABLED', false)
];
```

## Setup Poeditor

* Set environment variables in `.env`
  * Make sure that the api key has enough rights to upload and download terms and list project languages
```bash
POEDITOR_API_KEY=
POEDITOR_PROJECT_ID=
```

* Add reference language to your project. Best is to use one of the following.
  * `English (reference)` code=`en-reference` 
  * `English`, code=`en`
  * This language should not be edited in Poeditor itself and is only used to by developers
    ![img.png](img.png)
* In the project settings set `Default Reference Language` to `English (reference)`
  * This will help clients filling in the translations for other languages as they will see the english reference next to each term.

## Usage

You are now able to use the translation commands scan/upload/lint or download

**Upload translations**

To upload your reference translations to poeditor run this command:
```bash
php artisan translation:upload-reference
```

It will add all the terms to the project and set the translations of the reference language.


**Scan files**

To scan your project for translations run this command:
```bash
php artisan translation:scan
```

The command creates your `reference_language` .json file in `/resources/lang`


**Download translation languages**

To download languages from poeditor run this command:
```bash
php artisan translation:download {--include-reference:Download reference language as well}
```

**Lint translations**

After downloading the translations from poeditor it is possible to lint the files.
We will look for missing translations and for missing variables in the translations.
```bash
php artisan translation:lint
```

To automate this in the gitlab-ci pipeline add the command right after you download the translations.
**System translations**

If you want to translate system translations change the terms in eg `/resources/lang/en/auth.php`

From:
```php
'throttle' => 'Too many login attempts. Please try again in :seconds seconds.',
```

To
```php
'throttle' => __('Too many login attempts. Please try again in :seconds seconds.'),
```

Then it will be scanned and included in the synced terms.

## Automatically download language updates on deploy

The translation files need to be available in the container before deploying.  
To download the latest translations adapt the gitlab pipeline build stage to include those files in the container.  
Add the dowload script to the `.gitlab-ci.yml` file in your repo.
```yaml
build:php:
  script:
    - php artisan translation:download
```