# Bagaar MailChimp

## Installation

1.  `composer require bagaar/mailchimp-api:1.*`

2.  Add the serviceprovider to the providers array in config/app.php:
    ```php
    Bagaar\Mailchimp\Providers\MailchimpServiceProvider::class
    ```

3.  Run `php artisan vendor:publish` to publish the mailchimp.php config file.

4.  Set the environment vars:
    ```bash
    MAILCHIMP_APIKEY=you-api-key-here
    MAILCHIMP_TEST_MODE=false
    MAILCHIMP_LIST_SUBSCRIBERS=some-list-id
    ``` 

## Usage

1.  Constructor-inject or resolve the MailchimpService class:
    ```php
    use Bagaar\Mailchimp\Services\MailchimpService;

    protected $service

    public function __construct(MailchimpService $servcice)
    {
        $this->service = $service;
    }
    ```

2.  Quick overview of public methods:
    ```php
    // Return an instance of the base API
    public function getApi()
    
    // Get subscriber info
    public function getSubscriber($email, $list = '')

    // Add a subscriber to a list or update an existing subscriber
    public function subscribeOrUpdate($email, $mergeFields = [], $list = '', $options = [])

    // Remove a subscriber from a list
    public function unsubscribe($email, $list = '')
    ```
