<?php

namespace Bagaar\Mailchimp\Providers;

use Illuminate\Support\ServiceProvider;

class MailchimpServiceProvider extends ServiceProvider
{
    protected $controller;

    public function boot()
    {
        $this->publishes([__DIR__ . '/../config/config.php' => config_path('mailchimp.php')]);
    }

    public function register()
    {
        $this->prepareResources();
    }

    /**
     * Prepare the package resources.
     *
     * @return void
     */
    protected function prepareResources()
    {
        // Publish config
        $this->mergeConfigFrom(__DIR__ . '/../config/config.php', 'mailchimp');
    }
}
