<?php

namespace Bagaar\Reporting;

use Illuminate\Support\ServiceProvider;

class ReportingServiceProvider extends ServiceProvider
{
    public function boot()
    {
        $config = config('bagaar-reporting', []);
        foreach ($config as $model) {
            if (isset($model['observe']) && $model['observe'] === true) {
                $model['class']::saved(\Bagaar\Reporting\Listeners\ReportingListener::class);
            }
        }
    }

    public function register()
    {
        $this->publishes([__DIR__ . '/config.php' => config_path('bagaar-reporting.php')]);
        $this->commands([
            \Bagaar\Reporting\Commands\GenerateTables::class,
            \Bagaar\Reporting\Commands\GenerateReports::class,
            \Bagaar\Reporting\Commands\DeleteReports::class,
        ]);
    }
}