<?php

namespace Bagaar\Reporting\Commands;

use DB;
use Schema;
use Illuminate\Console\Command;
use Illuminate\Support\Composer;
use Illuminate\Filesystem\Filesystem;

class DeleteReports extends Command
{
    protected $name = 'reporting:delete';
    protected $description = 'Delete all generated reports';
    
    public function __construct()
    {
        parent::__construct();
    }

    public function fire()
    {
        $this->config = config('bagaar-reporting');
        if (!$this->confirm('Are you sure you want te delete all reports?')) {
            return;
        }
        foreach ($this->config as $model) {
            $table = array_key_exists('reports_table', $model) ? $model['reports_table'] : strtolower(array_slice(explode('\\', $model['class']), -1)[0]) . '_reports';
            if (Schema::hasTable($table)) {
                DB::table($table)->truncate();
                $this->info($table . ' cleared successfully!');
            }
        }
    }
}
