<?php

namespace Bagaar\Reporting\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Composer;
use Illuminate\Filesystem\Filesystem;

class GenerateTables extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'reporting:tables';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a migration for the reporting tables';

    /**
     * The filesystem instance.
     *
     * @var \Illuminate\Filesystem\Filesystem
     */
    protected $files;

    /**
     * @var \Illuminate\Support\Composer
     */
    protected $composer;

    protected $config;

    /**
     * Create a new cache table command instance.
     *
     * @param  \Illuminate\Filesystem\Filesystem  $files
     * @param  \Illuminate\Support\Composer  $composer
     * @return void
     */
    public function __construct(Filesystem $files, Composer $composer)
    {
        parent::__construct();

        $this->files = $files;
        $this->composer = $composer;
    }


    /**
     * @param $stub
     * @param $key
     * @param $value
     */
    private function inject(&$stub, $key, $value)
    {
        $stub = str_replace($key, $value, $stub);
    }


    /**
     * @param $stub
     * @param $model
     */
    private function injectIdentifier(&$stub, $model)
    {
        if( isset($model['identifier']) ){
            $this->inject($stub, '%identifier%', '$table->integer(\''.$model['identifier'].'\');');
        } else {
            $this->inject($stub, '%identifier%', '');
        }
    }

    private function injectFields(&$stub, array $fields)
    {
        $fields_str = '';

        foreach( $fields as $field ){
            $fields_str .= '$table->decimal(\''.$field.'\', 12, 4);' . "\n";
        }

        $this->inject($stub, '%fields%', $fields_str);
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function fire()
    {
        $this->composer->dumpAutoloads();

        $path = $this->laravel->databasePath().'/migrations';
        $this->config = config('bagaar-reporting');

        foreach ($this->config as $model) {

            $table = array_key_exists('reports_table', $model) ? $model['reports_table'] : strtolower(array_slice(explode('\\', $model['class']), -1)[0]) . '_reports';
            $name = 'create_' . $table . '_table';
            $fullPath = $this->laravel['migration.creator']->create($name, $path);

            $stub = $this->files->get(__DIR__.'/stubs/migration.stub');

            $this->inject($stub, '%class_name%', studly_case($name));
            $this->inject($stub, '%table_name%', $table);

            $this->injectIdentifier($stub, $model);
            $this->injectFields($stub, array_keys($model['fields']));

            $this->files->put($fullPath, $stub);

            $this->info($name . ' migration created successfully!');
        }

        $this->composer->dumpAutoloads();
    }

}
