<?php
namespace Bagaar\Reporting\Repositories;

use Carbon\Carbon;

class ReportRepository extends Repository
{


    protected $reportsTable;


    /**
     * @param $config
     */
    public function setModelConfig($config)
    {
        parent::setModelConfig($config);

        if ( isset($this->config['reports_table']) ){
            $this->reportsTable = $this->config['reports_table'];
        } else {
            $this->reportsTable = strtolower(array_slice(explode('\\', $this->config['class']), -1)[0]) . '_reports';
        }
    }


    /**
     * @param $identifier
     * @param Carbon $timestamp
     * @param $frequency
     * @param $values
     * @param bool $filled
     */
    public function createOrUpdateReport($identifier, Carbon $timestamp, $frequency, $values, $filled = false)
    {
        $query_data = [
            'timestamp' => $timestamp,
            'frequency' => $frequency
        ];

        $data = array_merge([
            'timestamp' => $timestamp,
            'frequency' => $frequency,
            'filled' => $filled,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ], $values);

        if ( $identifier !== null ){
            $query_data[ $this->identifier ] = $identifier;
            $data [ $this->identifier ] = $identifier;
        }

        $existing = \DB::table($this->reportsTable)->where($query_data)->first();

        if ( $existing ){
            \DB::table($this->reportsTable)->where('id', $existing->id)->update($data);
        } else {
            \DB::table($this->reportsTable)->insert($data);
        }

    }


    /**
     * @param $identifier
     * @param Carbon $timestamp
     * @param $frequency
     * @return mixed
     */
    public function getReport($identifier, Carbon $timestamp, $frequency)
    {
        $query = \DB::table($this->reportsTable)
            ->where('timestamp', $timestamp)
            ->where('frequency', $frequency);

        if ( $identifier !== null ){
            $query->where($this->identifier, $identifier);
        }

        return $query->first();
    }

    public function removeFilledReports($identifier, $frequency)
    {
        $query = \DB::table($this->reportsTable)
            ->where('frequency', $frequency)
            ->where('filled', true);

        if ( $identifier !== null ){
            $query->where($this->identifier, $identifier);
        }

        return $query->delete();
    }

}