<?php
namespace Bagaar\Reporting\Repositories;

use Carbon\Carbon;

class MeasureRepository extends Repository
{

    protected $filters = [];


    /**
     * @param $query
     * @return mixed
     */
    private function applyFilters($query)
    {
        foreach( $this->filters as $filter ){
            $f = $filter[0];
            $params = $filter[1];

            switch( count($params) ){
                case 0:
                    $query->{$f}();
                    break;
                case 1:
                    $query->{$f}($params[0]);
                    break;
                case 2:
                    $query->{$f}($params[0], $params[1]);
                    break;
                case 3:
                    $query->{$f}($params[0], $params[1], $params[2]);
                    break;
                case 4:
                    $query->{$f}($params[0], $params[1], $params[2], $params[3]);
                    break;
            }
        }

        return $query;
    }


    /**
     * @param $config
     */
    public function setModelConfig($config)
    {
        parent::setModelConfig($config);

        if ( isset($config['filters']) ) $this->filters = $config['filters'];
    }

    /**
     * @param null $identifier
     * @return mixed
     */
    public function getStartTime($identifier = null)
    {
        $query = $this->getModel()->orderBy($this->timestamp);
        $query = $this->applyFilters($query);

        if ( $identifier ){
            $query->where($this->identifier, $identifier);
        }

        $result = $query->first();

        if ( $result ){
            return $result->{$this->timestamp};
        } else {
            return null;
        }
    }


    /**
     * @return array
     */
    public function getIdentifiers()
    {
        if ( $this->identifier ){

            $query = $this->getModel()->select('*');
            $query = $this->applyFilters($query);

            return $query->pluck($this->identifier)->unique();
        }
        return [];
    }


    /**
     * @param $identifier
     * @param Carbon $start
     * @param Carbon $end
     * @return mixed
     */
    public function getMeasuresForRange($identifier, Carbon $start, Carbon $end)
    {
        $query = $this->getModel()->select(array_merge($this->fieldnames, [$this->timestamp], $this->extraFields));
        $query = $this->applyFilters($query);
        $query->orderBy($this->timestamp);

        if ( $identifier !== null ){
            $query->where($this->identifier, $identifier);
        }

        return $query->whereBetween($this->timestamp, [$start, $end])->get();
    }

}