<?php

/*
 * available intervals: hourly, daily, weekly, monthly
 * available report types: average, median, high, low
 * Set the key observe to true to enable on-the-fly report updates for a model
 * default timestamp field is 'created_at', this can be overwritten in the config when needed by setting a 'timestamp' key
 * default report table name is 'modelname_reports', this can be overwritten in the config when needed by setting a 'reports_table' key
 */

return [
    [
        'class' => App\Models\Battery::class,
        'identifier' => 'meter_id',
        'observe' => true,
        'fill_gaps' => true,
        'frequencies' => ['daily', 'weekly'],
        'fields' => [
            'battery' => 'average',
            'temperature' => 'median'
        ],
        'extra_fields' => [

        ],
        'filters' => [
            ['where', ['measured_at', '>', \Carbon\Carbon::create(2017, 1, 1)]],
            ['whereNotNull', ['value_top']],
            ['whereNotNull', ['value_bottom']],
        ]
    ]    
];
