<?php

namespace Bagaar\Reporting\Jobs;

use Bagaar\Reporting\Report;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;

class AddNewData implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    protected $model;

    public function __construct($model)
    {
        $this->model = $model;
    }

    public function handle()
    {
        app(Report::class)->update($this->model);
    }
}
